import os
from groupdocs.metadata import License, Metadata

def remove_pdf_metadata():
    # Get license file absolute path
    license_path = os.path.abspath("./GroupDocs.Total.lic")

    if os.path.exists(license_path):
        # Create License and set the path
        license = License()
        license.set_license(license_path)

    # Load the PDF file
    with Metadata("./business-plan.pdf") as metadata:
      # Remove the metadata
      metadata.sanitize()
     
      # Save the file with no metadata
      metadata.save("./no-metadata.pdf")

if __name__ == "__main__":
    remove_pdf_metadata()