'use strict';

// Import required modules
const groupdocs = require('@groupdocs/groupdocs.conversion');
const path = require('path')

// Get the source, output, and license paths from the command line arguments
const [sourcePath, outputPath, licensePath] = process.argv.slice(2);

// Get the license path from the command line arguments
if (licensePath) {
	const license = new groupdocs.License()
	license.setLicense(path.join(__dirname, licensePath));
}

// Create a new converter instance and load the source file
const converter = new groupdocs.Converter(sourcePath);

// Set the convert options for PDF format
const options = new groupdocs.PdfConvertOptions();

// Convert the file and save to the output path
converter.convert(outputPath, options);

// Exit the process
process.exit(0);