# GroupDocs.Conversion for Node.js via Java Example

In this example we convert documents to PDF format using GroupDocs.Conversion for Node.js via Java package.

## Prerequisites

- Node.js >= 20
- Java Runtime (JRE) 11+ (JDK for building native modules)

## CLI Usage

```bash
node convert-file.js <source> <output> [license]
```

Parameters:
- `source`: Path to the source file to convert (e.g., DOCX, XLSX, PPTX, etc.)
- `output`: Path where the converted PDF file will be saved
- `license`: Optional 3rd argument: path to `GroupDocs.Conversion.lic`
  - If omitted, the app runs in trial mode (may include watermarks)

Examples:

```bash
node convert-file.js ./work/source.docx ./work/converted.pdf
node convert-file.js ./work/source.docx ./work/converted.pdf ./work/GroupDocs.Conversion.lic
```

## Docker

### Build image

```bash
docker build -t groupdocs-conversion-sample:latest .
```

### Run container

Run without license

```bash
docker run --rm -v "${pwd}/work:/work" -w /work groupdocs-conversion-sample:latest source.docx converted.pdf
```

With license file

```bash
docker run --rm -v "${pwd}/work:/work" -w /work groupdocs-conversion-sample:latest source.docx converted.pdf GroupDocs.Conversion.lic
```

Notes:
- Mount a writable working directory where the output PDF will be created.
- Pass a license file as the 3rd argument to avoid watermarks and other trial limitations.
- The converter supports various input formats (DOCX, XLSX, PPTX, etc.) and converts them to PDF.
