'use strict';

const groupdocs = require('@groupdocs/groupdocs.comparison');

// Help message
const argv = process.argv.slice(2);
if (argv.includes('--help') || argv.includes('-h')) {
	console.log('Usage: node diff-files.js <source> <target> <output> <license>');
	process.exit(0);
}

// Get the source, target, output, and license paths from the command line arguments
const [sourcePath, targetPath, outputPath, licensePath] = argv;

// Set license if provided
if (licensePath) {
	const license = new groupdocs.License()
	license.setLicense(licensePath);
}

// Create a new comparer instance and add the source and target files
const comparer = new groupdocs.Comparer(sourcePath);

// Add the target file to the comparer
comparer.add(targetPath);

// Compare the source and target files and save the output to the output path
comparer.compare(outputPath);
console.log(`Diff file created at ${outputPath}`);

// Exit the process
process.exit(0);