# GroupDocs.Comparison for Node.js via Java Example

In this example we compare two documents and produce a DOCX diff using GroupDocs.Comparison for Node.js via Java package.

## Prerequisites

- Node.js >= 20
- Java Runtime (JRE) 11+ (JDK for building native modules)

## CLI Usage

```bash
node diff-files.js --help
node diff-files.js <source> <target> <output> [license]
```

License:
- Optional 4th argument: path to `GroupDocs.Comparison.lic`
- If omitted, the app runs in trial mode (may include watermarks)

Examples:

```bash
node diff-files.js ./work/proposal_v1.docx ./work/proposal_v2.docx ./work/proposal_diff.docx
node diff-files.js ./work/proposal_v1.docx ./work/proposal_v2.docx ./work/proposal_diff.docx ./work/GroupDocs.Comparison.lic
```

## Docker

### Build image

```bash
docker build -t groupdocs-comparison-sample:latest .
```

### Run container

Run without license

```bash
docker run --rm -v "${pwd}/work:/work" -w /work groupdocs-comparison-sample:latest proposal_v1.docx proposal_v2.docx proposal_diff.docx
```

With license file

```bash
docker run --rm -v "${pwd}/work:/work" -w /work groupdocs-comparison-sample:latest proposal_v1.docx proposal_v2.docx proposal_diff.docx GroupDocs.Comparison.lic
```

Notes:
- Mount a writable working directory where the output diff will be created.
- Pass a license file as the 4th argument to avoid watermarks and other trial limitations.
